--5 Mistakes you are probably making with SQL Server

--DEMO 1: Settings and configuration

--Default settings
EXEC sp_configure 'show advanced options', 1;
RECONFIGURE;
GO
EXEC sp_configure 'max degree of parallelism', 0;
RECONFIGURE
GO 


EXEC sp_configure 'cost threshold for parallelism',5;
RECONFIGURE
GO
EXEC sp_configure 'optimize for ad hoc workloads', 0;
RECONFIGURE

--Get AdventureWorks from Codeplex
--Create the big adventure table from http://sqlblog.com/blogs/adam_machanic/archive/2011/10/17/thinking-big-adventure.aspx

USE AdventureWorks2014;

--Clear out cache. Don't do this on production!!
DBCC DROPCLEANBUFFERS;

SELECT ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;


--Change MAXDOP to 1 -- Great for SharePoint!
EXEC sp_configure 'max degree of parallelism', 1;
RECONFIGURE
GO 


--Clear out cache. Don't do this on production!!
DBCC DROPCLEANBUFFERS;
GO

SELECT ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

EXEC sp_configure 'max degree of parallelism', 2;
RECONFIGURE
GO 
DBCC DROPCLEANBUFFERS;
GO

SELECT ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

GO 

--Increase threshold
--Usually start at 35, but needed 200 to stop parallelism on this query
EXEC sp_configure 'cost threshold for parallelism',200;
RECONFIGURE;
GO
DBCC DROPCLEANBUFFERS;
GO

SELECT ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

--Back to default settings
EXEC sp_configure 'max degree of parallelism', 0;
RECONFIGURE
GO 
EXEC sp_configure 'cost threshold for parallelism',5;
RECONFIGURE
GO
EXEC sp_configure 'optimize for ad hoc workloads', 0;
RECONFIGURE

--Free procedure cache. Don't do this!
DBCC FREEPROCCACHE;
GO

SELECT TOP(10) ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

--View plan cache
SELECT DB_NAME(t.dbid) AS DatabaseName,text, p.query_plan
FROM sys.dm_exec_cached_plans cp 
CROSS APPLY sys.dm_exec_sql_text(cp.plan_handle) t
CROSS APPLY sys.dm_exec_query_plan(cp.plan_handle) p
WHERE [text] LIKE 'SELECT TOP(10) ProductID%';

EXEC sp_configure 'optimize for ad hoc workloads', 1;
RECONFIGURE
GO
--Free procedure cache. Don't do this!
DBCC FREEPROCCACHE;
GO

SELECT TOP(10) ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

SELECT DB_NAME(t.dbid) AS DatabaseName,text, p.query_plan
FROM sys.dm_exec_cached_plans cp 
CROSS APPLY sys.dm_exec_sql_text(cp.plan_handle) t
CROSS APPLY sys.dm_exec_query_plan(cp.plan_handle) p
WHERE [text] LIKE 'SELECT TOP(10) ProductID%';

SELECT TOP(10) ProductID, SUM(ActualCost) AS Sales
FROM dbo.bigTransactionHistory
GROUP BY ProductID;

SELECT DB_NAME(t.dbid) AS DatabaseName,text, p.query_plan
FROM sys.dm_exec_cached_plans cp 
CROSS APPLY sys.dm_exec_sql_text(cp.plan_handle) t
CROSS APPLY sys.dm_exec_query_plan(cp.plan_handle) p
WHERE [text] LIKE 'SELECT TOP(10) ProductID%';


--END DEMO 1

--DEMO 2: Maintenance
--Start with Index Maintenance Wizard
--Show Ola Hallengren Scripts 
IF OBJECT_ID('IndexTest') IS NOT NULL DROP TABLE IndexTest;

CREATE TABLE IndexTest(ID INT NOT NULL, 
	CharValue CHAR(896) DEFAULT 'AAA');
GO
CREATE CLUSTERED INDEX CI_IndexTest ON IndexTest(ID);


WITH Numbers AS(
	SELECT TOP(10000) ROW_NUMBER() OVER(ORDER BY A.name) AS Number
	FROM sys.objects A 
	CROSS JOIN sys.objects B 
	CROSS JOIN sys.objects C)
INSERT INTO IndexTest(ID) 
SELECT Number
FROM Numbers;



SELECT index_type_desc, index_depth, index_level, 
	avg_fragmentation_in_percent,page_count, record_count  
FROM sys.dm_db_index_physical_stats(DB_ID(), 
	OBJECT_ID('dbo.IndexTest'),NULL, NULL, 'Detailed');

UPDATE IndexTest 
SET ID = ID * 10 
WHERE ID % 10 = 1; 

SELECT index_type_desc, index_depth, index_level, 
	avg_fragmentation_in_percent,page_count, record_count  
FROM sys.dm_db_index_physical_stats(DB_ID(), 
	OBJECT_ID('dbo.IndexTest'),NULL, NULL, 'Detailed');


UPDATE IndexTest 
SET ID = ID * 10 
WHERE ID % 10 = 2; 

SELECT index_type_desc, index_depth, index_level, 
	avg_fragmentation_in_percent,page_count, record_count  
FROM sys.dm_db_index_physical_stats(DB_ID(), 
	OBJECT_ID('dbo.IndexTest'),NULL, NULL, 'Detailed');

ALTER INDEX [CI_IndexTest] ON IndexTest REBUILD;

SELECT index_type_desc, index_depth, index_level, 
	avg_fragmentation_in_percent,page_count, record_count  
FROM sys.dm_db_index_physical_stats(DB_ID(), 
	OBJECT_ID('dbo.IndexTest'),NULL, NULL, 'Detailed');


--END DEMO 2


--DEMO 3: Code Reuse

--Can't do this
SELECT CustomerID, OrderDate, SalesOrderID, SUM(TotalDue) AS SubTotal
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

--Create a function to separate the logic
IF OBJECT_ID('dbo.udf_GetTotalSales') IS NOT NULL DROP FUNCTION dbo.udf_GetTotalSales;
GO
CREATE FUNCTION  [dbo].[udf_GetTotalSales](@customerid int)
RETURNS MONEY BEGIN 
	DECLARE @total MONEY
	SELECT @total = sum(totaldue) 
	FROM sales.SalesOrderHeader
	WHERE customerid = @customerid;
	RETURN @total;
END

SELECT CustomerID, OrderDate, SalesOrderID, TotalDue, 
	 dbo.udf_GetTotalSales(CustomerID) AS CustSubTotal
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

--A better solution!
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue, 
	 SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustSubTotal
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

--Review plan
SELECT CustomerID, dbo.udf_GetTotalSales(CustomerID) AS CustSubTotal
FROM Sales.Customer
ORDER BY CustomerID;

GO
IF OBJECT_ID('dbo.udf_GetFirstOrder') IS NOT NULL DROP FUNCTION dbo.udf_GetFirstOrder;
GO
CREATE FUNCTION dbo.udf_GetFirstOrderID(@CustomerID INT)
RETURNS INT BEGIN
	DECLARE @SalesOrderID INT;
	SELECT @SalesOrderID = MIN(SalesOrderID) 
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = @CustomerID;

	RETURN @SalesOrderID;
END
GO
IF OBJECT_ID('dbo.udf_GetOrderAmt') IS NOT NULL DROP FUNCTION dbo.udf_GetOrderAmt;
GO
CREATE FUNCTION dbo.udf_GetOrderAmt(@SalesOrderID INT)
RETURNS MONEY BEGIN
	DECLARE @Amt MONEY;
	SELECT @Amt = TotalDue
	FROM Sales.SalesOrderHeader 
	WHERE SalesOrderID = @SalesOrderID;
	RETURN @AMT;
END
GO

IF OBJECT_ID('dbo.udf_CompareToFirstOrder') IS NOT NULL DROP FUNCTION dbo.udf_CompareToFirstOrder;
GO
CREATE FUNCTION dbo.udf_CompareToFirstOrder(@CustomerID INT, @SalesOrderID INT)
RETURNS MONEY BEGIN 
	--Get first OrderID
	DECLARE @FirstOrderID INT;
	SET @FirstOrderID = dbo.udf_GetFirstOrderID(@CustomerID);

	--Get first order amt
	DECLARE @FirstOrderAmt MONEY;
	SET @FirstOrderAmt = dbo.udf_GetOrderAmt(@FirstOrderID);

	--Get Current Order Amount
	DECLARE @CurrentOrderAmt MONEY;
	SET @CurrentOrderAmt = dbo.udf_GetOrderAmt(@SalesOrderID);

	--Subtract
	RETURN @CurrentOrderAmt - @FirstOrderAmt;
END

GO
--Using nested function
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue,
	dbo.udf_CompareToFirstOrder(CustomerID, SalesOrderID) AS OrderChangeFromFirst
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

--Another way to write
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue,
	TotalDue - FIRST_VALUE(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesORderID) AS OrderChangeFromFirst
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

GO

--Table Valued Function
SELECT CustomerID, CI.*
FROM Sales.Customer 
CROSS APPLY [dbo].[ufnGetContactInformation](PersonID) CI;

SELECT YEAR(OrderDate) AS OrderYear INTO #Years 
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate);


SELECT STM.* 
FROM #Years
CROSS APPLY [dbo].[udf_SalesTotalsByMonth](OrderYear) AS STM;




--END DEMO 3


--DEMO 4: Index Strategy
--create a demo table
IF OBJECT_ID('dbo.DEMO_SalesDetail') IS NOT NULL 
	DROP TABLE dbo.DEMO_SalesDetail;

SELECT * INTO dbo.DEMO_SalesDetail FROM Sales.SalesOrderDetail ;
ALTER TABLE dbo.DEMO_SalesDetail ADD PRIMARY KEY CLUSTERED
	(SalesOrderID, SalesOrderDetailID)
   
 
SET STATISTICS IO ON;
--Turn on execution plan
SELECT SalesOrderID, ProductID
FROM dbo.DEMO_SalesDetail
WHERE ProductID = 919;


--Add the index
CREATE NONCLUSTERED INDEX NDX_DEMO_SalesDetail ON 
	dbo.DEMO_SalesDetail (ProductID);

SELECT SalesOrderID, ProductID
FROM dbo.DEMO_SalesDetail
WHERE ProductID = 919;

--Key lookup
SELECT SalesOrderID, ProductID, OrderQty  
FROM dbo.DEMO_SalesDetail 
WHERE ProductID = 919;

--Scan
SELECT SalesOrderID, ProductID, OrderQty  
FROM dbo.DEMO_SalesDetail 
WHERE ProductID = 707;

DROP INDEX NDX_DEMO_SalesDetail ON dbo.DEMO_SalesDetail;

CREATE NONCLUSTERED INDEX NDX_DEMO_SalesDetail
ON dbo.DEMO_SalesDetail (ProductID) INCLUDE(OrderQty);

SELECT SalesOrderID, SalesOrderDetailID,
	ProductID, OrderQty  
FROM dbo.DEMO_SalesDetail 
WHERE ProductID = 707;

--Find Missing Indexes
--From Glenn Berry http://www.sqlskills.com/blogs/glenn/
SELECT CONVERT(decimal(18,2), user_seeks * avg_total_user_cost * (avg_user_impact * 0.01)) AS [index_advantage], 
migs.last_user_seek, mid.[statement] AS [Database.Schema.Table],
mid.equality_columns, mid.inequality_columns, mid.included_columns,
migs.unique_compiles, migs.user_seeks, migs.avg_total_user_cost, migs.avg_user_impact
FROM sys.dm_db_missing_index_group_stats AS migs WITH (NOLOCK)
INNER JOIN sys.dm_db_missing_index_groups AS mig WITH (NOLOCK)
ON migs.group_handle = mig.index_group_handle
INNER JOIN sys.dm_db_missing_index_details AS mid WITH (NOLOCK)
ON mig.index_handle = mid.index_handle
ORDER BY index_advantage DESC OPTION (RECOMPILE);


--Find possibly unneeded indexes
SELECT OBJECT_NAME(s.[object_id]) AS [Table Name], i.name AS [Index Name], i.index_id, 
i.is_disabled, i.is_hypothetical, i.has_filter, i.fill_factor,
user_updates AS [Total Writes], user_seeks + user_scans + user_lookups AS [Total Reads],
user_updates - (user_seeks + user_scans + user_lookups) AS [Difference]
FROM sys.dm_db_index_usage_stats AS s WITH (NOLOCK)
INNER JOIN sys.indexes AS i WITH (NOLOCK)
ON s.[object_id] = i.[object_id]
AND i.index_id = s.index_id
WHERE OBJECTPROPERTY(s.[object_id],'IsUserTable') = 1
AND s.database_id = DB_ID()
AND user_updates > (user_seeks + user_scans + user_lookups)
AND i.index_id > 1
ORDER BY [Difference] DESC, [Total Writes] DESC, [Total Reads] ASC OPTION (RECOMPILE);


--END DEMO 4

--DEMO 5: SARGability
SELECT LastName, FirstName 
FROM Person.Person
WHERE LEFT(LastName,1) = 'S';

--Better to do this:
SELECT LastName, FirstName 
FROM Person.Person
WHERE LastName LIKE 'S%';


--But this is not so good
SELECT FirstName, LastName
FROM Person.Person 
WHERE LastName LIKE '%mith';


SELECT FirstName, LastName 
FROM Person.Person 
WHERE LastName NOT LIKE 'Smit%';


SELECT FirstName, LastName 
FROM Person.Person 
WHERE Firstname = 'Kevin';


CREATE INDEX ix_Test ON Sales.SalesOrderHeader(OrderDate);

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate = '2012-01-01';

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE YEAR(OrderDate) = 2012;

--Better to do this
SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate >= '2012/01/01' AND OrderDate < '2013/01/01';

drop index ix_Test on sales.salesorderheader;

DECLARE @ID varchar(10);
SET @ID = '11000'
SELECT CustomerID, SalesOrderID 
FROM Sales.SalesOrderHeader
WHERE CustomerID = @ID;

CREATE TABLE #conversion(ID varchar(10));

insert into #conversion
select object_id 
from sys.objects;

select * from #conversion
create index ix_test on #conversion(id);
GO
DECLARE @ID INT;
SET @ID = 3;

SELECT ID 
FROM #conversion 
where ID = @id;
Go
DECLARE @ID VARCHAR(10);
SET @ID = 3;

SELECT ID 
FROM #conversion 
where ID = @id;






	





